% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saromatic.R
\name{saro.geometry}
\alias{saro.geometry}
\title{Compute Geometric Parameters of S-Aromatic Motifs}
\usage{
saro.geometry(pdb, rA, chainA = 'A', rB, chainB = 'A')
}
\arguments{
\item{pdb}{either the path to the PDB file of interest or the 4-letters identifier.}

\item{rA}{numeric position of one of the two residues involved in the motif.}

\item{chainA}{a character indicating the chain to which belong the first residue.}

\item{rB}{numeric position of the second residue involved in the motif.}

\item{chainB}{a character indicating the chain to which belong the second residue.}
}
\value{
The function returns a dataframe providing the coordinates of the sulfur atom and the centroid (centroids when the aromatic residue is tryptophan), as well as the distance (ångströms) and the angle (degrees) mentioned above.
}
\description{
Computes distances and angles of S-aromatic motifs.
}
\details{
The distance between the delta sulfur atom and the centroid of the aromatic ring is computed, as well as the angle between this vector and the one perpendicular to the plane containing the aromatic ring. Based on the distance (d) and the angle (theta) the user decide whether the two residues are considered to be S-bonded or not (usually when d < 7 and theta < 60º).
}
\examples{
\dontrun{saro.geometry('1CLL', rA = 141, rB = 145)}
}
\references{
Reid, Lindley & Thornton, FEBS Lett. 1985, 190, 209-213.
}
\seealso{
saro.motif(), saro.dist()
}
\author{
Juan Carlos Aledo
}
