% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saromatic.R
\name{saro.motif}
\alias{saro.motif}
\title{Search for S-Aromatic Motifs}
\usage{
saro.motif(pdb, threshold = 7, onlySaro = TRUE)
}
\arguments{
\item{pdb}{either the path to the PDB file of interest or the 4-letters identifier.}

\item{threshold}{distance in ångströms, between the S atom and the aromatic ring centroid, used as threshold.}

\item{onlySaro}{logical, if FALSE the output includes information about Met residues that are not involved in S-aromatic motifs.}
}
\value{
The function returns a dataframe reporting the S-aromatic motifs found for the protein of interest.
}
\description{
Searches for S-aromatic motifs in proteins.
}
\details{
For each methionyl residue taking place in a S-aromatic motif, this function computes the aromatic residues involved, the distance between the delta sulfur and the aromatic ring's centroid, as well as the angle between the sulfur-aromatic vector and the normal vector of the plane containing the aromatic ring.
}
\examples{
\dontrun{saro.motif('1CLL')}
}
\references{
Reid, Lindley & Thornton, FEBS Lett. 1985, 190, 209-213.
}
\seealso{
saro.dist(), saro.geometry()
}
\author{
Juan Carlos Aledo
}
