% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{jack_knife}
\alias{jack_knife}
\title{Ranks leverage observations from Jackknife method.}
\usage{
jack_knife(x)
}
\arguments{
\item{x}{A numeric variable. Missing values are removed by default.}
}
\value{
Data frame with the ranked squared differences.
}
\description{
\code{jack_knife} Ranks the squared differences between mean values from Jackknife analysis
(arithmetic mean estimated by removing one observation at a time) and the original mean value.
}
\examples{
x <- rnorm(10, 170, 8)
x
mean(x)
jack_knife(x)

x <- rnorm(100, 170, 8)
mean(x)
head(jack_knife(x))
}
\seealso{
\link{rank_leverage}
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
