% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{rank_influence}
\alias{rank_influence}
\title{Ranks observations based upon influence measures on models.}
\usage{
rank_influence(model)
}
\arguments{
\item{model}{A generalised linear model object.}
}
\description{
\code{rank_influence} calculates influence measures of each data observation on models and then ranks them.
}
\details{
\code{rank_influence} is a wrap function that calls \link{influence.measures}, ranks observations on
their significance influence on the model and displays the 10 most influential observations
(if they are significant).
}
\examples{
data(diet, package = "Epi")
model <- glm(chd ~ fibre, data = diet, family = binomial)
rank_influence(model)
}
\seealso{
\code{\link[stats]{influence.measures}}.
}
