% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{bst}
\alias{bst}
\title{Bootstrap Confidence Intervals.}
\usage{
bst(x, stat = "mean", n = 1000, CI = 95, digits = 2)
}
\arguments{
\item{x}{A numerical variable. Missing observations are removed by default.}

\item{stat}{Statistic, either "mean" (default), "median" or "gmean" (geometric mean).}

\item{n}{Number of replicates for the bootstrap (n=1000 by default).}

\item{CI}{Confidence intervals (CI=95 by default).}

\item{digits}{Number of digits for rounding (default = 2).}
}
\value{
A data frame with the estimate and confidence intervals.
}
\description{
\code{bst} estimates confidence intervals around the \code{\link[base]{mean}}, \code{\link[stats]{median}} or \code{\link{geo_mean}}.
}
\examples{
data(IgM, package = "ISwR")
bst(IgM, "median")

bst(IgM, "gmean")
}
