% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities-helpers.R
\name{normalizing_constant}
\alias{normalizing_constant}
\alias{I}
\alias{J}
\title{Normalizing Constants for the Publication Selection Meta-Analysis Model}
\usage{
I(sigma, theta, alpha, eta)

J(sigma, theta0, tau, alpha, eta)
}
\arguments{
\item{sigma}{Numeric; The standard deviation of the study, due to
sampling error.}

\item{theta}{Numeric; The mean of the underlying effect size.}

\item{alpha}{Numeric vector; Specifies the thresholds for publication
bias.}

\item{eta}{Numeric vector; Containing the probabilities of being a study
with the given p-value from being published. This is normalized so that
the maximal element is 1.}

\item{theta0}{Numeric; The mean of the underlying effect size
distribution.}

\item{tau}{Numeric; The standard deviation of the underlying effect
size distribution.}
}
\value{
The normalizing constant.
}
\description{
Normalizing constants for the publication selection meta-Analysis model.
These are used in several other functions. The underlying effect size
distribution is normal and the selection is one-sided.
}
\details{
The function \code{I} calculates the normalizing constant for the density of
the observed effect sizes. The function \code{J} calculates the
normalizing constant for the density of the effect size distribution.
}
\keyword{internal}
