% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt_select.R
\name{pt_select}
\alias{pt_select}
\title{Retrieve data from the PubTator database.}
\usage{
pt_select(db_con, table_name, columns = NULL, keys = NULL,
  keytype = NULL, limit = Inf)
}
\arguments{
\item{db_con}{A connection to the PubTator sqlite database, as created via
pubator_connector.}

\item{table_name}{The name of the table of interest. Valid tables can be
found using pt_tables. Capitalization does not matter.}

\item{columns}{A character vector of the names of the columns of interest.
Capitalization does not matter.}

\item{keys}{A vector specifying which values must be in the keytype column to
enable retrieval. No filtering is performed if keys = NULL.}

\item{keytype}{The column in which the keys should be searched for.}

\item{limit}{The maximum number of rows the query should return. All rows
passing filtering (if any) are returned if limit = Inf.}
}
\value{
A data.frame.
}
\description{
Retrieve data from the PubTator database.
}
\examples{
\donttest{
db_con <- pt_connector(pt_path)
pt_select(
  db_con,
  "gene",
  columns = c("ENTREZID","Resource","MENTIONS","PMID"),
  keys = c("7356", "4199", "7018"),
  keytype = "ENTREZID",
  limit = 10
)
}
}
