% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generic.R
\name{getParams}
\alias{getParams}
\title{Get pulseModel params}
\usage{
getParams(object, stage, genename = NULL)
}
\arguments{
\item{object}{a 'pulseTDmodel' that has been calculated with \code{\link{estimateParams}}}

\item{stage}{A character is one of three stages of transcriptional dynamics, transcription, processing and degradation.}

\item{genename}{a vector, default is NULL
\itemize{
 \item If it is NULL: Calculate the transcriptional dynamic rate of all genes
 \item If it is a gene vector: only calculate the transcriptional dynamic rate of a given gene vector
 \item If it is a numerical vector: only calculate the transcriptional dynamic rate of the gene corresponding to a given value.
}}
}
\value{
A matrix or vector containing six parameters: h0,h1,h2,t1 t2,beta
}
\description{
It is used to obtain the parameters of the pulse function J Comput Biol (2009 Feb) <doi:10.1089/cmb.2008.13TT>, including transcription parameters, degradation parameters and processing parameters.
You can use these parameters to analyze transcriptional characteristics, including steady-state analysis.
At the same time, you can use \code{\link{pulseModel}} to view the curve corresponding to the parameter.
}
\examples{
data('pulseRates', package='pulseTD')
TimeGrid <- c(0, 15, 30, 45, 60, 75, 90, 105, 120, 135, 150, 165, 180)
pulseRates_correct <- correctionParams(pulseRates)
transcription_params = getParams(pulseRates,'transcription')
degradation_params = getParams(pulseRates, 'degradation')
processing_params = getParams(pulseRates, 'processing')
head(transcription_params)
head(degradation_params)
head(processing_params)
transcription_params = getParams(pulseRates, 'transcription', genename=c(1,2,3))
head(transcription_params)
###
transcription_pulse = pulseModel(as.matrix(transcription_params[1,]), TimeGrid)
degradation_pulse = pulseModel(as.matrix(degradation_params[1,]), TimeGrid)
processing_pulse = pulseModel(as.matrix(processing_params[1,]), TimeGrid)

}
