% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_waic.R
\name{calc_waic}
\alias{calc_waic}
\title{Calculate a block version of Watanabe-Akaike Information Criterion (WAIC)}
\usage{
calc_waic(vote_info, years_v = NULL, prob_array)
}
\arguments{
\item{vote_info}{A logical vote matrix (or a rollcall object) in which rows represent members and columns represent issues.
The entries should be FALSE ("No"), TRUE ("Yes"), or NA (missing data).}

\item{years_v}{A vector representing the time period for each vote in the model. This is defultly set as `NULL` for a static model.}

\item{prob_array}{An array of probabilities with three dimensions.}
}
\value{
The block WAIC value for a static PUM or a vector of WAIC by time for a dynamic PUM.
}
\description{
This function is used to get the WAIC value when blocking members
}
\examples{
\donttest{
# Long-running example
data(h116)
h116.c = preprocess_rollcall(h116)
hyperparams <- list(beta_mean = 0, beta_var = 1, alpha_mean = c(0, 0),
                    alpha_scale = 5, delta_mean = c(-2, 10), delta_scale = sqrt(10))
control <- list(num_iter = 2, burn_in = 0, keep_iter = 1, flip_rate = 0.1)
h116.c.pum <- sample_pum_static(h116.c, hyperparams,
                                  control, pos_leg = grep("SCALISE", rownames(h116.c$votes)),
                                  verbose = FALSE, pre_run = NULL, appended = FALSE)
h116.c.pum.predprob = predict_pum(h116.c, years_v = NULL, h116.c.pum)
h116.c.pum.waic = calc_waic(h116.c, prob_array = h116.c.pum.predprob)
}
}
