### Function for getting critical value for method = P
get_cv_P <- function(ksig) 
{
  
  ### Critical values based on Irwin-Hall distribution (obtained with Mathematica)
  cv.irwin <- c(0.025, 0.2236068, 0.5313293, 0.8801117, 1.2461056, 1.624144, 
                2.0123298, 2.4083589, 2.8107664, 3.2185166, 3.6308158, 4.0470508, 
                4.466735, 4.8894743, 5.3149446, 5.7428752, 6.1730373, 6.6052357, 
                7.0393019, 7.4750896, 7.9124706, 8.3513318, 8.791573, 9.2331047, 
                9.6758467, 10.119727, 10.56468, 11.0106467, 11.4575729, 11.9054094, 
                12.3541107, 12.8036353, 13.2539447, 13.7050034, 14.1567786, 14.6092396, 
                15.062358, 15.5161073, 15.9704626, 16.4254007, 16.8808999, 17.3369397, 
                17.7935008, 18.2505652, 18.7081158, 19.1661363, 19.6246116, 20.0835271, 
                20.5428692, 21.0026248, 21.4627816, 21.9233278, 22.3842521, 22.845544, 
                23.3071933, 23.7691902, 24.2315254, 24.6941901, 25.1571758, 25.6204742, 
                26.0840778, 26.5479788, 27.0121703, 27.4766452, 27.9413969, 28.4064191, 
                28.8717057, 29.3372507, 29.8030484, 30.2690934, 30.7353804, 31.2019042, 
                31.66866, 32.135643, 32.6028487, 33.0702724, 33.53791, 34.0057574, 
                34.4738104, 34.9420652, 35.410518, 35.8791651, 36.3480031, 36.8170284, 
                37.2862377, 37.7556278, 38.2251955, 38.6949378, 39.1648517, 39.6349343, 
                40.1051829, 40.5755946, 41.0461668, 41.516897, 41.9877825, 42.4588211, 
                42.9300102, 43.4013476, 43.872831, 44.3444582)
  
  if (ksig <= 100) 
  { # Select critical value from prespecified vector
    cv.P <- cv.irwin[ksig]
  } else 
  { # Else approximate the critical value with the normal distribution
    cv.P <- qnorm(0.025, mean = ksig * 0.5, sd = sqrt(ksig/12))
  }
  
  return(cv.P)
  
} 