% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/puni_star.R
\name{puni_star}
\alias{puni_star}
\title{p-uniform*}
\usage{
puni_star(
  mi,
  ri,
  ni,
  sdi,
  m1i,
  m2i,
  n1i,
  n2i,
  sd1i,
  sd2i,
  tobs,
  yi,
  vi,
  alpha = 0.05,
  side,
  method = "ML",
  boot = FALSE,
  control
)
}
\arguments{
\item{mi}{A vector of group means for one-sample means}

\item{ri}{A vector of raw correlations}

\item{ni}{A vector of sample sizes for one-sample means and correlations}

\item{sdi}{A vector of standard deviations for one-sample means}

\item{m1i}{A vector of means in group 1 for two-independent means}

\item{m2i}{A vector of means in group 2 for two-independent means}

\item{n1i}{A vector of sample sizes in group 1 for two-independent means}

\item{n2i}{A vector of sample sizes in group 2 for two-independent means}

\item{sd1i}{A vector of standard deviations in group 1 for two-independent means}

\item{sd2i}{A vector of standard deviations in group 2 for two-independent means}

\item{tobs}{A vector of t-values}

\item{yi}{A vector of standardized effect sizes (see Details)}

\item{vi}{A vector of sampling variances belonging to the standardized effect
sizes (see Details)}

\item{alpha}{A numerical value specifying the alpha level as used in primary studies
(default is 0.05 but see Details).}

\item{side}{A character indicating whether the effect sizes in the primary studies
are in the right-tail of the distribution (i.e., positive)  or in the left-tail
of the distribution (i.e., negative) (either \code{"right"} or \code{"left"})}

\item{method}{A character indicating the method to be used \code{"ML"} (default),
\code{"P"}, or \code{"LNP"}}

\item{boot}{A logical indicating whether the p-value of testing whether the 
between-study variance is zero for methods \code{P} and \code{LNP} should be 
obtained by means of a parametric bootstrap. The default value is FALSE.}

\item{control}{An optional list of elements that give the user more control 
over the optimization and root-finding algorithms (see Note)}
}
\value{
\item{est}{p-uniform*'s effect size estimate}
\item{ci.lb}{lower bound of p-uniform*'s 95\% confidence interval of the effect size}
\item{ci.ub}{upper bound of p-uniform*'s 95\% confidence interval of the effect size}
\item{L.0}{test statistic of p-uniform*'s test of the null hypothesis of no effect}
\item{pval.0}{one-tailed p-value of p-uniform*'s test of null hypothesis of no effect}
\item{tau2}{p-uniform*'s estimate of the between-study variance}
\item{tau2.lb}{lower bound of p-uniform*'s 95\% confidence interval of the 
between-study variance}
\item{tau2.ub}{upper bound of p-uniform*'s 95\% confidence interval of the 
between-study variance}
\item{L.het}{test statistic of p-uniform*'s test of the null hypothesis of no 
between-study variance}
\item{pval.het}{one-tailed p-value of p-uniform*'s test of null hypothesis of 
no between-study variance}
\item{pval.boot}{one-tailed p-value of p-uniform*'s test of null hypothesis 
of no between-study variance obtained with a parametric bootstrap}
\item{...}{a number of additional elements}
}
\description{
Function to apply the p-uniform* method for one-sample mean, two-independent means,
and one raw correlation coefficient as described in van Aert and van Assen (2023).
}
\details{
Three different effect size measures can be used as input for the \code{puni_star}
function: one-sample means, two-independent means, and raw correlation coefficients.
Analyzing one-sample means and two-independent means can be done by either providing
the function group means (\code{mi} or \code{m1i} and \code{m2i}), standard deviations
(\code{sdi} or \code{sd1i} and \code{sd2i}), and sample sizes (\code{ni} or
\code{n1i} and \code{n2i}) or t-values (\code{tobs}) and sample sizes (\code{ni}
or \code{n1i} and \code{n2i}). Both options should be accompanied with input
for the arguments \code{side}, \code{method}, and \code{alpha}. See the Example section for
examples. Raw correlation coefficients can be analyzed by supplying \code{ri}
and \code{ni} to the \code{puni_star} function next to input for the arguments
\code{side}, \code{method}, and \code{alpha}.

It is also possible to specify the standardized effect sizes and its sampling
variances directly via the \code{yi} and \code{vi} arguments. However, extensive
knowledge about computing standardized effect sizes and its sampling variances
is required and specifying standardized effect sizes and sampling variances is
not recommended to be used if the p-values in the primary studies are not computed
with a z-test. In case the p-values in the primary studies were computed with,
for instance, a t-test, the p-values of a z-test and t-test do not exactly
coincide and studies may be incorrectly included as a statistically significant or 
nonsignificant effect size. Furthermore, critical values in the primary studies 
are not transformed to critical z-values if \code{yi} and \code{vi} are used 
as input. This yields less accurate results.

The \code{puni_star} function assumes that two-tailed hypothesis tests were conducted
in the primary studies. In case one-tailed hypothesis tests were conducted in 
the primary studies, the submitted \code{alpha} argument to the \code{puni_star} 
function has to be multiplied by two. For example, if one-tailed hypothesis tests were 
conducted with an alpha level of .05, an alpha of 0.1 has to be submitted to 
the \code{puni_star} function.

Note that only one effect size measure can be specified at a time. A combination
of effect size measures usually causes true heterogeneity among effect sizes and
including different effect size measures is therefore not recommended.

\bold{Selecting a method}

Three different methods are currently implemented in the \code{puni_star} function. 
The \code{ML} method refers to maximum likelihood estimation of the effect size 
and the between-study variance. Profile likelihood confidence intervals around 
the estimates are computed by means of inverting the likelihood-ratio test. 
Likelihood-ratio tests are used for testing the null hypotheses of no effect 
and no between-study variance. The \code{ML} method is the recommended method 
for applying p-uniform*. 

The two other methods (\code{P} and \code{LNP}) are moment based estimators. 
The method \code{P} is based on the distribution of the sum of independent 
uniformly distributed random variables (Irwin-Hall distribution) and the 
\code{LNP} method refers to Fisher's method (1950, Chapter 4). For these methods, 
a p-value for testing the null hypothesis of no between-study variance can also be 
obtained by means of a parametric bootstrap. This is necessary since the data 
is otherwise first used for estimating the effect size in the procedure for testing 
the null hypothesis of no between-study variance and then also used for computing 
a p-value. The test of no effect is not available for the methods \code{P} and \code{LNP} 
and the publication bias test for these methods is not yet implemented.
}
\note{
The \code{control} argument in the \code{puni_star} function is an optional 
argument that gives the user more control over the optimization and root-finding 
algorithms. This can be especially useful if estimation of the method does not 
converge and NAs are returned by the function. The \code{control} argument should 
be specified as a list containing one or more elements. For example, 
\code{control = list(verbose = TRUE)} Default values are used if an element is 
not specified. The following elements can be specified by the user:

\itemize{
\item{\code{proc.ml:}}{ A character indicating with optimization procedure should 
be used for the method \code{ML}. The initial implementation of p-uniform* iteratively
optimized the profile log-likelihood functions. As of version 0.2.6 of this 
package, the default optimization routine estimates both parameters at the 
same time. The old optimization procedure can be used by specifying \code{proc.ml = "prof"}}.
\item{\code{stval.d:}}{ An integer that is the starting value of the effect 
size for estimation. This starting value is used for the method \code{ML} and 
is only needed when both parameters are estimated at the same time. See argument 
\code{proc.ml} for more information. The default value is the mean of the effect
sizes in the meta-analysis.}
\item{\code{stval.tau:}}{ An integer that is the starting value of tau for estimation.
This starting value is used for the methods \code{ML}, \code{P}, and \code{LNP}. 
The default value is the standard deviation of the effect sizes in the meta-analysis.}
\item{\code{int:}}{ A vector of length two that indicates the lower and upper 
bound of the interval that is used for estimating the effect size. The effect 
size estimate should be included in this interval. This interval is used for the 
methods \code{ML}, \code{P}, and \code{LNP} and its default values are (-2, 2).}
\item{\code{bounds.int}}{ A vector of length two that is used for determining the 
bounds for estimating the effect size with \code{P} and \code{LNP}. The default 
values are a function of the \code{yi}. The lower bound is the minimum \code{yi} 
minus 1 and the upper bound is the maximum \code{yi} plus 1. The effect size 
has to be between the lower and upper bound.}
\item{\code{tau.int:}}{ A vector of length two that indicates the lower and upper 
bound of the interval that is used for estimating the between-study variance. 
The estimate of the between-study variance should be included in this interval. 
This interval is used for the methods \code{ML}, \code{P}, and \code{LNP} 
and its default values are (0, 2).}
\item{\code{est.ci:}}{ A vector of length two indicating the values that are 
subtracted from and added to the estimate of the effect size for computing the 
95\% confidence intervals. This vector is used for the methods \code{ML}, 
\code{P}, and \code{LNP} and its default values are (3, 3). To give an example, 
estimates for the lower and upper bound around the effect size estimate are 
searched on the interval (est-3, est) and (est, est+3), respectively.}
\item{\code{tau.ci:}}{ A vector of length two indicating the values that are 
added to the estimate of the between-study variance for computing the 95\% confidence 
intervals. This vector is used for the methods \code{ML}, \code{P}, and \code{LNP} 
and its default values are (3, 1).}
\item{\code{tol:}}{ A number indicating the desired accuracy of the estimates. 
This number is used for the methods \code{ML}, \code{P}, and \code{LNP} and its 
default value is 0.001.} 
\item{\code{maxit:}}{ An integer indicating the maximum number of iterations 
that is used for estimating the effect size and between-study variance. This 
number is used for the methods \code{ML}, \code{P}, and \code{LNP} and its default 
value is 300.}
\item{\code{fnscale:}}{ An integer that can be used for scaling the log-likelihood
value in the optimization. \code{fnscale} is one of the control arguments of 
the \code{optim()} function that is internally used for optimization when the 
\code{ML} method is used and both parameters are estimated at the same time. 
See the argument \code{proc.ml} above #' and the documentation of the \code{optim()} 
function for more information.} 
\item{\code{verbose:}}{ A logical indicating whether information should be printed 
about the algorithm for estimating the effect size and between-study variance. 
This logical is used for the methods \code{ML}, \code{P}, and \code{LNP} and 
its default value is FALSE.}
\item{\code{reps:}}{ An integer indicating the number of bootstrap replications
for computing the bootstrapped p-value for the test of no between-study variance.
This integer is used for the methods \code{P} and \code{LNP} and its default value 
is 1000.}
}
}
\examples{
### Generate data for one-sample mean with mu = 0.2 and tau^2 = 0.01
set.seed(123)
ni <- rep(50, 25)
sdi <- rep(1, 25)
ui <- rnorm(25, mean = 0.2, sd = 0.1)
mi <- rnorm(25, mean = ui, sd = sdi/sqrt(ni))
tobs <- mi/(sdi/sqrt(ni))

### Apply p-uniform* method using sample means
puni_star(mi = mi, ni = ni, sdi = sdi, alpha = 0.05, side = "right", method = "ML")

### Apply p-uniform* method using t-values
puni_star(tobs = tobs, ni = ni, alpha = 0.05, side = "right", method = "ML")

}
\references{
Fisher, R.A. (1950). Statistical methods for research workers (11th ed.).
London: Oliver & Boyd.

van Aert, R.C.M., & van Assen, M.A.L.M. (2023). Correcting for 
publication bias in a meta-analysis with the p-uniform* method. Manuscript submitted  
for publication. Preprint: https://osf.io/preprints/bitss/zqjr9/
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
