% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/split_by.R
\name{split_by}
\alias{order_by}
\alias{sort_by}
\alias{split_by}
\title{Split, order and sort lists by their components.}
\usage{
split_by(.x, .f, ...)

order_by(.x, .f, ...)

sort_by(.x, .f, ...)
}
\arguments{
\item{.x}{A list or vector.}

\item{.f}{A function, formula or string.

  If a function, it is used as is.

  If a formula, e.g. \code{~ .x + 2}, it is converted to a function with
  a three arguments, \code{.x} or \code{.}, \code{.y}, \code{.z}. This allows
  you to create very compact anonymous functions of up to 3 variables.

  If a string, e.g. \code{"y"}, it is converted to an extractor function,
  \code{function(x) x[["y"]]}.}

\item{...}{Additional arguments passed on to \code{.f}.}
}
\description{
Split, order and sort lists by their components.
}
\examples{
l1 <- zip_n(list(x = sample(10), y = 1:10))
l1
l1 \%>\% order_by("x")
l1 \%>\% sort_by("x")

l2 <- rerun(5, g = sample(2, 1), y = rdunif(5, 10))
l2 \%>\% split_by("g") \%>\% str()
l2 \%>\% split_by("g") \%>\% map(. \%>\% map("y"))
}

