% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_pushover_user.R
\name{set_pushover_user}
\alias{get_pushover_group}
\alias{get_pushover_user}
\alias{pushover_user.isset}
\alias{set_pushover_group}
\alias{set_pushover_user}
\alias{unset_pushover_group}
\alias{unset_pushover_user}
\title{Set, get, and unset the Pushover user/group key}
\usage{
set_pushover_user(user = NULL, ask = interactive())

get_pushover_user(ask = interactive())

unset_pushover_user()

pushover_user.isset()

set_pushover_group(user = NULL, ask = interactive())

get_pushover_group(ask = interactive())

unset_pushover_group()
}
\arguments{
\item{user}{The user or group key to be used. If none is provided, a prompt
will request the key.}

\item{ask}{Whether or not to ask for the key if none is provided. Note that
this only works for interactive sessions.}
}
\value{
\code{get_pushover_user} returns a string containing the current
user or group key

\code{pushover_user.isset} returns a logical value indicating whether
the user/group is set (\code{TRUE}) or not (\code{FALSE}).
}
\description{
\code{set_pushover_user} sets the Pushover user or group key to be used in
subsequent commands, \code{get_pushover_user} gets the user or group key
that is currently set, and \code{unset_pushover_user} unsets the key.
\code{pushover_user.isset} indicates whether or not the user/group key has
been set.
}
\details{
\code{set_pushover_group}, \code{get_pushover_group}, and
\code{unset_pushover_group} are aliases for these functions.

\code{set_pushover_user} only sets the Pushover user or group for the current
session. If a different value is specified in .Renviron, that value will be
used in future sessions. Similarly, \code{unset_pushover_user} will only
unset the user or group for the current session.

User keys can be found within the settings of the Pushover app or
by logging in to \url{https://pushover.net}. Group keys can be found after
creating a delivery group in your account on \url{https://pushover.net}.
}
\examples{
\dontrun{
set_pushover_user(user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
}

