% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvlrt-postprocessing-utils.R
\name{extract_AE_names}
\alias{extract_AE_names}
\alias{extract_Drug_names}
\alias{set_AE_names}
\alias{set_Drug_names}
\title{Extracting and setting AE and Drug names from a pvlrt object}
\usage{
extract_AE_names(object)

extract_Drug_names(object)

set_AE_names(object, old, new)

set_Drug_names(object, old, new)
}
\arguments{
\item{object}{a \code{pvlrt} object, which is the output of the function
\link{pvlrt} or one of its wrappers such as \link{lrt_zi_poisson},
\link{lrt_poisson} and \code{lrt_vanilla_poisson}.}

\item{old}{character vector containing the old names}

\item{new}{character vector containing the new names}
}
\value{
\itemize{
\item \code{extract_AE_names} returns a character vector of the names of the
AEs in the input \code{pvlrt} object
\item \code{extract_Drug_names} returns a character vector of the names of the Drugs
in the input \code{pvlrt} object
\item \code{set_AE_names} returns a new \code{pvlrt} object with updated AE names as
specified through the arguments \code{old} and \code{new}.
\item \code{set_Drug_names} returns a new \code{pvlrt} object with updated Drug names as
specified through the arguments \code{old} and \code{new}.
}
}
\description{
Extracting and setting AE and Drug names from a pvlrt object
}
\note{
Because a \code{pvlrt} object is simply a reclassified matrix, the AE (rows)
and Drug (columns) names can also be extracted/modified through \link{rownames} and
\link{colnames} respectively.
}
\examples{
# 500 bootstrap iterations (nsim) in the example below
# are for quick demonstration only --
# we recommended setting nsim to 10000 (default) or bigger

test1 <- pvlrt(statin46, test_zi = TRUE, nsim = 500)
extract_AE_names(test1)
extract_Drug_names(test1)

set_AE_names(test1, old = "Rhabdomyolysis", new = "Rhabdo")
set_Drug_names(test1, old = "other", new = "Other-Drugs")


}
\seealso{
\link{pvlrt}
}
