% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Sum_p}
\alias{Sum_p}
\title{p-variation summation function}
\usage{
Sum_p(x, p, lag = 1)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{p}{a number indicating the power in summing function.}

\item{lag}{a number, indicating the lag of differences.}
}
\value{
The number equal to \code{sum((abs(diff(x, lag)))^p)}
}
\description{
It is the sum of absolute differences in the power of p.
}
\details{
This is a function that must be maximized by taking a proper subset of \code{x}, i.e. if \code{prt} is a
p-variation partition of sample \code{x}, then \code{Sum_p(x[prt], p) == pvar(x, p)$value}.
}
\examples{
x = rbridge(1000)
pv = pvar(x, 2); pv
# Sum_p in supreme partition and the value form pvar must match
Sum_p(x[pv$partition], 2)
pv
}
\seealso{
\code{\link{pvar}}
}

