% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRC_short2.R
\name{MRC_short2}
\alias{MRC_short2}
\title{Compute Multiple Regression shortcuts with three predictors for Ind Coefficients
Requires correlations between all variables as sample size. Means and sds are option. Also computes Power(All)}
\usage{
MRC_short2(
  ry1_1,
  ry2_1,
  ry3_1 = NULL,
  r12_1,
  r13_1 = NULL,
  r23_1 = NULL,
  n1,
  ry1_2,
  ry2_2,
  ry3_2 = NULL,
  r12_2,
  r13_2 = NULL,
  r23_2 = NULL,
  n2,
  alpha = 0.05,
  my_1 = 0,
  m1_1 = 0,
  m2_1 = 0,
  m3_1 = 0,
  s1_1 = 1,
  s2_1 = 1,
  s3_1 = 1,
  sy_1 = 1,
  my_2 = 0,
  m1_2 = 0,
  m2_2 = 0,
  m3_2 = 0,
  s1_2 = 1,
  s2_2 = 1,
  s3_2 = 1,
  sy_2 = 1
)
}
\arguments{
\item{ry1_1}{Correlation between DV (y) and first predictor (1), first group}

\item{ry2_1}{Correlation between DV (y) and second predictor (2), first group}

\item{ry3_1}{Correlation between DV (y) and third predictor (3), first group}

\item{r12_1}{Correlation between first (1) and second predictor (2), first group}

\item{r13_1}{Correlation between first (1) and third predictor (3), first group}

\item{r23_1}{Correlation between second (2) and third predictor (3), first group}

\item{n1}{Sample size, first group}

\item{ry1_2}{Correlation between DV (y) and first predictor (1), second group}

\item{ry2_2}{Correlation between DV (y) and second predictor (2), second group}

\item{ry3_2}{Correlation between DV (y) and third predictor (3), second group}

\item{r12_2}{Correlation between first (1) and second predictor (2), second group}

\item{r13_2}{Correlation between first (1) and third predictor (3), second group}

\item{r23_2}{Correlation between second (2) and third predictor (3), second group}

\item{n2}{Sample size, second group}

\item{alpha}{Type I error (default is .05)}

\item{my_1}{Mean of DV (default is 0), first group}

\item{m1_1}{Mean of first predictor (default is 0), first group}

\item{m2_1}{Mean of second predictor (default is 0), first group}

\item{m3_1}{Mean of third predictor (default is 0), first group}

\item{s1_1}{Standard deviation of first predictor (default is 1), first group}

\item{s2_1}{Standard deviation of second predictor (default is 1), first group}

\item{s3_1}{Standard deviation of third predictor (default is 1), first group}

\item{sy_1}{Standard deviation of DV (default is 1), first group}

\item{my_2}{Mean of DV (default is 0), second group}

\item{m1_2}{Mean of first predictor (default is 0), second group}

\item{m2_2}{Mean of second predictor (default is 0), second group}

\item{m3_2}{Mean of third predictor (default is 0), second group}

\item{s1_2}{Standard deviation of first predictor (default is 1), second group}

\item{s2_2}{Standard deviation of second predictor (default is 1), second group}

\item{s3_2}{Standard deviation of third predictor (default is 1), second group}

\item{sy_2}{Standard deviation of DV (default is 1), second group}
}
\value{
Multiple Regression shortcuts with three predictors for Ind Coefficients
}
\description{
Compute Multiple Regression shortcuts with three predictors for Ind Coefficients
Requires correlations between all variables as sample size. Means and sds are option. Also computes Power(All)
}
\examples{
MRC_short2(ry1_1=.40, ry2_1=.40, ry3_1 =-.40, r12_1=-.15,r13_1=-.60, r23_1=.25,
ry1_2=.40, ry2_2=.10, ry3_2 =-.40, r12_2=-.15,r13_2=-.60, r23_2=.25,
n1=50,n2=50,alpha=.05,my_1=1,m1_1=1,m2_1=1,m3_1=1,
sy_1=7,s1_1=1,s2_1=1,s3_1=2,
my_2=1,m1_2=1,m2_2=1,m3_2=1,sy_2=7,s1_2=1,s2_2=1,s3_2=2)
}
