% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depcorr0.R
\name{depcorr0}
\alias{depcorr0}
\title{Compute Power for Comparing Two Dependent Correlations, No Variables in Common
Takes correlations and range of values. First variable in each pair is termed predictor, second is DV}
\usage{
depcorr0(
  r12,
  rxy,
  r1x,
  r1y,
  r2x,
  r2y,
  nlow,
  nhigh,
  alpha = 0.05,
  tails = 2,
  by = 1
)
}
\arguments{
\item{r12}{Correlation between the predictor and DV (first set of measures)}

\item{rxy}{Correlation between the predictor and DV (second set of measures)}

\item{r1x}{Correlation between the predictor (first measure) and the predictor variable (first measure)}

\item{r1y}{Correlation between the predictor (first measure) and the dependent variable (second measure)}

\item{r2x}{Correlation between the DV (first measure) and the predictor variable (first measure)}

\item{r2y}{Correlation between the DV (first measure) and the dependent variable (second measure)}

\item{nlow}{Starting sample size}

\item{nhigh}{Ending sample size}

\item{alpha}{Type I error (default is .05)}

\item{tails}{one or two-tailed tests (default is 2)}

\item{by}{Incremental increase in sample size from low to high}
}
\value{
Power for Comparing Two Dependent Correlations, No Variables in Common
}
\description{
Compute Power for Comparing Two Dependent Correlations, No Variables in Common
Takes correlations and range of values. First variable in each pair is termed predictor, second is DV
}
\examples{
depcorr0(r12=.4,rxy=.7,r1x=.3,r1y=.1,r2x=.45,r2y=.35,nlow=20,nhigh=200,by=10, tails=2)
}
