% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medserial.R
\name{medserial}
\alias{medserial}
\title{Compute Power for Serial Mediation Effects
Requires correlations between all variables as sample size.
This approach calculates power for the serial mediation using
joint significance (recommended)}
\usage{
medserial(rxm1, rxm2, rxy, rm1m2, rym1, rym2, n, alpha = 0.05, reps = 1000)
}
\arguments{
\item{rxm1}{Correlation between predictor (x) and first mediator (m1)}

\item{rxm2}{Correlation between predictor (x) and second mediator (m2)}

\item{rxy}{Correlation between DV (y) and predictor (x)}

\item{rm1m2}{Correlation first mediator (m1) and second mediator (m2)}

\item{rym1}{Correlation between DV (y) and first mediator (m1)}

\item{rym2}{Correlation between DV (y) and second mediator (m2)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{reps}{Number of samples (default is 1000)}
}
\value{
Power for Serial Mediated (Indirect) Effects
}
\description{
Compute Power for Serial Mediation Effects
Requires correlations between all variables as sample size.
This approach calculates power for the serial mediation using
joint significance (recommended)
}
\examples{
\donttest{medserial(rxm1=.3, rxm2=.3, rxy=-.35, rym1=-.5,rym2=-.5,
rm1m2=.7,n=150)}
}
