% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_utils.R
\name{df.spd}
\alias{df.spd}
\title{Create data frame for split-plot design}
\usage{
df.spd(trt.main, trt.sub, label, replicates)
}
\arguments{
\item{trt.main}{an integer-valued vector specifying the treatment structure at
main plot level, similar to \code{\link{df.crd}}.}

\item{trt.sub}{an integer-valued vector specifying the treatment structure at
sub plot level, similar to \code{trt.main}.}

\item{label}{Optional. A list of character vectors, each corresponding to a treatment factor.
The name of each vector specifies the factor's name, and its elements provide the labels for that factor's levels.
If no labels are provided, default labels will be used. For a single treatment factor, the default is
\code{list(trt = c("1", "2", ...))}, and for two treatment factors, the default is
\code{list(facA = c("1", "2", ...), facB = c("1", "2", ...))}.
For split-plot designs, the defaults are similar but include the ".main" and ".sub" suffixes for main plot and subplot factors.
For example:
\code{list(trt.main = c("1", "2", ...), trt.sub = c("1", "2", ...))} and
\code{list(facA.main = c("1", "2", ...), facB.main = c("1", "2", ...),
      facA.sub = c("1", "2", ...), facB.sub = c("1", "2", ...))}.
Label sets should be arranged so that the main plot factors come first, followed by the subplot factors.}

\item{replicates}{the number of experimental units (main plots) per treatment
of main plot factors.}
}
\value{
a data.frame representing the data structure of the design
}
\description{
Create data frame for split-plot design
}
