% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_startswith.R
\name{pystr_startswith}
\alias{pystr_startswith}
\title{Check the prefix of a string.}
\usage{
pystr_startswith(str, prefix, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A string.}

\item{prefix}{A string, character vector, or list of strings.}

\item{start}{An integer.}

\item{end}{An integer.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Return \code{TRUE} if the string \code{str} starts with the specified
\code{prefix}, otherwise return \code{FALSE}.
}
\details{
\code{prefix} can also be a vector or list of prefixes to look for. With optional
\code{start}, test string beginning at that position. With optional
\code{end}, stop comparing string at that position.
}
\examples{
pystr_startswith("www.example.com", "www.")
pystr_startswith("example.com", "www.")
pystr_startswith("www.example.com", "example", 5)
pystr_startswith("http://example.com", c("http://", "https://"))
pystr_startswith("http://example.com", list("http://", "https://"))
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.startswith}
}
\seealso{
\code{\link{pystr_endswith}}
}

