/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleMultiItem {
    private static final Logger LOGGER = Logger.getLogger(RuleMultiItem.class.getName());
    public static final String INTERVAL_SEPARATOR = ";";
    private ArrayList<AttributeValue> attributeValues;
    private ArrayList<ValueOrigin> valueOrigin;
    public ValueOrigin lastModificationType;
    private Attribute attribute;

    protected RuleMultiItem(ArrayList<AttributeValue> attributeValues, Attribute attribute) {
        this.lastModificationType = null;
        this.attribute = attribute;
        this.attributeValues = attributeValues;
        this.valueOrigin = new ArrayList();
        attributeValues.stream().forEach(value -> this.valueOrigin.add(ValueOrigin.core));
    }

    protected RuleMultiItem(ArrayList<AttributeValue> attributeValues, ArrayList<ValueOrigin> valueOrigin, Attribute attribute, ValueOrigin lastModificationType) {
        this.lastModificationType = lastModificationType;
        this.attribute = attribute;
        this.attributeValues = attributeValues;
        this.valueOrigin = valueOrigin;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public ValueOrigin getValueOrigin(AttributeValue val) {
        int index = this.attributeValues.indexOf(val);
        if (index < 0) {
            return null;
        }
        return this.valueOrigin.get(index);
    }

    public ArrayList<AttributeValue> getAttributeValues() {
        return this.attributeValues;
    }

    public ArrayList<ValueOrigin> getValueOrigin() {
        return this.valueOrigin;
    }

    public ArrayList<RuleMultiItem> getNeighbourhood() {
        ArrayList<RuleMultiItem> neighbourhood;
        if (this.attribute.getType() == AttributeType.numerical) {
            neighbourhood = new ArrayList();
            RuleMultiItem leftExtension = this.getExtended(ValueOrigin.extend_higher);
            RuleMultiItem rightExtension = this.getExtended(ValueOrigin.extend_lower);
            if (leftExtension != null) {
                neighbourhood.add(leftExtension);
            }
            if (rightExtension != null) {
                neighbourhood.add(rightExtension);
            }
        } else {
            neighbourhood = this.getExtended_Nominal_Greedy();
        }
        return neighbourhood;
    }

    public ArrayList<RuleMultiItem> getExtended_Nominal_Greedy() {
        ArrayList<RuleMultiItem> rmiCandidates = new ArrayList<RuleMultiItem>();
        Collection<AttributeValue> candidates = this.attribute.getAllValues();
        candidates.removeAll(this.attributeValues);
        if (candidates.isEmpty()) {
            LOGGER.log(Level.FINE, "Cannot perform greedy nominal extension, no values remaining on item:{0}", this.toString(true, true, false));
            return rmiCandidates;
        }
        ArrayList<ValueOrigin> copyValOrigin = new ArrayList<ValueOrigin>(this.valueOrigin);
        copyValOrigin.add(ValueOrigin.extend_greedy);
        candidates.forEach(candidate -> {
            ArrayList<AttributeValue> copy = new ArrayList<AttributeValue>(this.attributeValues);
            copy.add((AttributeValue)candidate);
            rmiCandidates.add(new RuleMultiItem(copy, copyValOrigin, this.attribute, ValueOrigin.extend_greedy));
        });
        return rmiCandidates;
    }

    public RuleMultiItem getExtended(ValueOrigin extensionType) {
        if (this.attribute.getType() == AttributeType.nominal) {
            LOGGER.log(Level.FINE, "Extension {0} not possible for nominal attributes", (Object)extensionType);
            return null;
        }
        AttributeValue toBeAddedLower = null;
        AttributeValue toBeAddedHigher = null;
        if (extensionType == ValueOrigin.extend_lower || extensionType == ValueOrigin.fuzzy_border) {
            if (this.attributeValues.isEmpty()) {
                LOGGER.severe("Rule with zero values");
            } else {
                toBeAddedLower = this.attribute.getAdjacentLower(this.attributeValues.get(0));
            }
        }
        if (extensionType == ValueOrigin.extend_higher || extensionType == ValueOrigin.fuzzy_border) {
            if (this.attributeValues.isEmpty()) {
                LOGGER.severe("Rule with zero values");
            } else {
                toBeAddedHigher = this.attribute.getAdjacentHigher(this.attributeValues.get(this.attributeValues.size() - 1));
            }
        }
        if (extensionType != ValueOrigin.extend_lower && extensionType != ValueOrigin.extend_higher && extensionType != ValueOrigin.fuzzy_border) {
            throw new UnsupportedOperationException("Unsupported extension operation");
        }
        if (toBeAddedLower == null && toBeAddedHigher == null) {
            LOGGER.log(Level.FINE, "Cannot perform ''{0}'', no values remaining on item:{1}", new Object[]{extensionType, this.toString(true, true, false)});
            return null;
        }
        LOGGER.log(Level.FINE, "Performing ''{0}'' on multiitem:{1}", new Object[]{extensionType, this.toString(true, true, false)});
        ArrayList<AttributeValue> copy = new ArrayList<AttributeValue>(this.attributeValues);
        ArrayList<ValueOrigin> copyValOrigin = new ArrayList<ValueOrigin>(this.valueOrigin);
        if (toBeAddedLower != null) {
            copy.add(0, toBeAddedLower);
            copyValOrigin.add(0, extensionType);
        }
        if (toBeAddedHigher != null) {
            copyValOrigin.add(copy.size(), extensionType);
            copy.add(copy.size(), toBeAddedHigher);
        }
        return new RuleMultiItem(copy, copyValOrigin, this.attribute, extensionType);
    }

    public String toString(boolean withAttributeName, boolean valueOrigin, boolean succint) {
        StringBuilder sb = new StringBuilder();
        if (withAttributeName) {
            sb.append(this.attribute.getName()).append("=");
        }
        String del = "";
        if (succint & this.attribute.getType() == AttributeType.numerical & this.attributeValues.size() > 1) {
            sb.append("[");
            sb.append(this.attributeValues.get(0));
            sb.append(INTERVAL_SEPARATOR);
            sb.append(this.attributeValues.get(this.attributeValues.size() - 1));
            sb.append("]");
        } else {
            for (AttributeValue value : this.attributeValues) {
                sb.append(del);
                sb.append(value.toString(false, valueOrigin));
                del = ",";
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, false, false);
    }

    public Set<Transaction> getSupportingTransactions() {
        return this.attributeValues.parallelStream().map(value -> value.getTransactions()).reduce(Collections.newSetFromMap(new ConcurrentHashMap()), (set, set2) -> {
            set.addAll(set2);
            return set;
        });
    }
}

