% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMARC.R
\name{arulesCBA2arcCBAModel}
\alias{arulesCBA2arcCBAModel}
\title{arulesCBA2arcCBAModel Converts a model created by \pkg{arulesCBA} so that it can be passed to qCBA}
\usage{
arulesCBA2arcCBAModel(
  arulesCBAModel,
  cutPoints,
  rawDataset,
  classAtt,
  attTypes
)
}
\arguments{
\item{arulesCBAModel}{aobject returned  by arulesCBA::CBA()}

\item{cutPoints}{specification of cutpoints applied on the data before they were passed to \code{rCBA::build}}

\item{rawDataset}{the raw data (before discretization). This dataset is used to guess attribute types if attTypes is not passed}

\item{classAtt}{the name of the class attribute}

\item{attTypes}{vector of attribute types of the original data.  If set to null, you need to pass rawDataset.}
}
\description{
Creates instance of arc CBAmodel class from the \pkg{arc} package
Instance of CBAmodel can then be passed to \link{qcba}
}
\examples{

if (! requireNamespace("arulesCBA", quietly = TRUE)) {
 message("Please install arulesCBA: install.packages('arulesCBA')")
}  else {
 message("The following code might cause the 'pruning exception' rCBA error on some installations")
 classAtt <- "Species"
 discrModel <- discrNumeric(iris, classAtt)
 irisDisc <- as.data.frame(lapply(discrModel$Disc.data, as.factor))
 arulesCBAModel <- arulesCBA::CBA(Species ~ ., data = irisDisc, supp = 0.1, 
  conf=0.9)
 CBAmodel <- arulesCBA2arcCBAModel(arulesCBAModel, discrModel$cutp,  iris, classAtt)
 qCBAmodel <- qcba(cbaRuleModel=CBAmodel,datadf=iris)
 print(qCBAmodel@rules)
 }


}
