% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_reports.R
\name{run_report}
\alias{run_report}
\title{Run a report}
\usage{
run_report(
  subdomain,
  auth,
  table_id,
  report_id,
  agent = NULL,
  skip = 0,
  top = 0,
  type_suffix = FALSE,
  paginate = TRUE
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{table_id}{Character vector with one element. Found in the URL of a
Quickbase table between /db/ and ?}

\item{report_id}{Character vector with one element. Found in the 'Reports &
Charts' page in Quickbase and in the report URL.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{skip}{Optional. Integer. The number of rows to skip from the top of a
record set.}

\item{top}{Optional. Integer. The limit on the number of records to pull
starting at the top of a record set.}

\item{type_suffix}{Optional. Logical. Set TRUE to append each field label
with its Quickbase data type.}

\item{paginate}{Optional. Logical. Set TRUE to recursively call the API until
all report pages are collected.}
}
\value{
A tibble.
}
\description{
Run a report and get its data.
}
\examples{
\dontrun{

   # Get all data in a report
   my_tibble <- run_report(subdomain = "abc",
       auth = keyring::key_get("qb_example"),
       table_id = "bn9d8iesz",
       report_id = "1")

   # Get rows 3 to 6 from a report
   my_tibble <- run_report(subdomain = "abc.quickbase.com",
       auth = keyring::key_get("qb_example"),
       table_id = "bn9d8iesz",
       report_id = "1",
       skip = 2,
       top = 3)
}
}
\references{
\href{https://developer.quickbase.com}{Quickbase API
documentation}
}
