% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_tables.R
\name{get_tables}
\alias{get_tables}
\title{Get all tables}
\usage{
get_tables(subdomain, auth, app_id, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{app_id}{Character vector with one element. Unique identifier of an app.
Found in the URL of the app's homepage after /db/}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A tibble.
}
\description{
Get metadata for all tables in an app.
}
\examples{
\dontrun{
   get_tables(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              app_id = "bsf5hphe5")
}
}
