% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqcs.t2.r
\name{mqcs.t2}
\alias{mqcs.t2}
\alias{mqcs.t2.default}
\alias{mqcs.t2.mqcd}
\title{Function to plot t2 Hotelling chart}
\usage{
mqcs.t2(x, ...)

\method{mqcs.t2}{default}(
  x,
  data.name = NULL,
  limits = NULL,
  Xmv = NULL,
  S = NULL,
  colm = NULL,
  alpha = 0.01,
  phase = 1,
  method = "sw",
  plot = FALSE,
  ...
)

\method{mqcs.t2}{mqcd}(
  x,
  limits = NULL,
  Xmv = NULL,
  S = NULL,
  colm = NULL,
  alpha = 0.01,
  phase = 1,
  method = "sw",
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{an R object (used to select the method). See details.}

\item{...}{arguments passed to or from methods.}

\item{data.name}{a string that specifies the title displayed on the plots. 
If not provided it is taken from the name of the object's data.}

\item{limits}{a two-values vector specifying the control limits.}

\item{Xmv}{is the mean vector. It is only specified for Phase II or when the parameters of the distribution are known.}

\item{S}{is the sample covariance matrix. It is only used for Phase II or when the parameters of the distribution are known.}

\item{colm}{is the number of samples (m) and it is only used in Hotelling control chart for Phase II}

\item{alpha}{it is the the significance level (0.01 for default)}

\item{phase}{Allows to select the type of UCL to use. Only values of phase = 1 or 2 are allowed.}

\item{method}{is the method employed to compute the covatiance matrix
in the individual observation case. Two methods are used "sw" 
for compute according to (Sullivan,Woodall 1996a) and "hm" 
by (Holmes,Mergen 1993)}

\item{plot}{a logical value indicating that it should be plotted.}
}
\description{
This function is used to compute statistics required by the t2 chart.
}
\examples{

##
##  Continuous data 
##
library(qcr)
data(dowel1)
str(dowel1)
data.mqcd <- mqcd(dowel1)
res.mqcs <- mqcs.t2(data.mqcd)
summary(res.mqcs)
plot(res.mqcs, title =" Hotelling Control Chart for dowel1")

data(archery1)
str(archery1)
data.mqcd <- mqcd(archery1)
res.mqcs <- mqcs.t2(data.mqcd)
summary(res.mqcs)
plot(res.mqcs, title =" Hotelling Control Chart for archery1")
}
\author{
Edgar Santos-Fernandez
}
