% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/outlier_labeler.R
\name{outlier_labeler}
\alias{outlier_labeler}
\title{Locate Outliers in Numeric String}
\usage{
outlier_labeler(x, standardize = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{standardize}{logical.  If \code{TRUE} scales the vector first.}

\item{\ldots}{Other arguments passed to \code{\link[base]{scale}}.}
}
\value{
Returns a matrix (one column) of possible outliers coded as
\code{"3sd"}, \code{"2sd"} and \code{"1.5sd"}, corresponding to >= to 3, 2,
or 1.5 standard deviations.
}
\description{
Locate and label possible outliers in a string.
}
\examples{
\dontrun{
outlier_labeler(mtcars$hp)[20:32]
by(mtcars$mpg, mtcars$cyl, outlier_labeler)
tapply(mtcars$mpg, mtcars$cyl, outlier_labeler)
}
}
\seealso{
\code{\link[base]{scale}}
}
\keyword{scale,}
\keyword{standardize}

