% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gantt.R
\name{gantt}
\alias{gantt}
\alias{plot_gantt_base}
\title{Gantt Durations}
\usage{
gantt(text.var, grouping.var, units = "words", sums = FALSE,
  col.sep = "_")

plot_gantt_base(x, sums = NULL, fill.colors = NULL, box.color = "white",
  title = NULL)
}
\arguments{
\item{text.var}{The text variable}

\item{grouping.var}{The grouping variables. Also takes a single grouping 
variable or a list of 1 or more grouping variables.}

\item{units}{The unit of measurement to analyze.  One of the strings 
\code{"character"}, \code{"syllable"}, \code{"word"}, or \code{"sentence"}.}

\item{sums}{logical.  If \code{TRUE} reports and (optionally (or plots) the 
total units used by grouping variable(s).}

\item{col.sep}{The character string to use to separate pasted variables in 
the merged grouping variable header/name.}

\item{x}{n object of the class "gantt".}

\item{fill.colors}{The colors of the Gantt plot bars.  Either a single color 
or a length equal to the number of grouping variable(s).  If \code{NULL}, 
\code{rainbow} is used.}

\item{box.color}{A color to wrap the boxes with.}

\item{title}{An optional title.}
}
\value{
Returns a data frame of start and end times by grouping variable(s) 
or optionally returns a list of two: (1) A data frame of the total units 
used by grouping variable(s) and (2) a data frame of start and end times 
by grouping variable(s).
}
\description{
\code{gantt} - Generates start and end times of supplied text selections 
(i.e., text selections are determined by any number of grouping variables).

\code{plot_gantt_base} - For internal use.
}
\note{
For non-repeated measures data use \code{\link[qdap]{gantt}}.  For
more flexible plotting needs use \code{\link[qdap]{gantt_wrap}} over the 
generic plotting method.
}
\examples{
\dontrun{
(a <- gantt(DATA$state, DATA$person))  
plot(a)
plot(a, base = TRUE)

(b <- gantt(DATA$state, DATA$person, sums = TRUE)) 
plot(b)
plot(b, base = FALSE) 

(d <- gantt(DATA$state, list(DATA$sex, DATA$adult)))        
plot(d)

x <- gantt(mraja1$dialogue, mraja1$person) 
plot(x, base = TRUE)
plot(x, , base = TRUE, box.color = "black") 

z <- gantt(mraja1$dialogue, mraja1$sex)  
plot(z)  
                                                          
e <- with(mraja1, gantt(dialogue, list(fam.aff, sex, died), 
   units = "characters", sums = TRUE))
plot(e)  
     
f <- gantt(mraja1$dialogue, mraja1$person, units = "syllables",
    sums = TRUE)
plot(f, box.color = "red")
plot(f, base = FALSE)

dat <- gantt(mraja1$dialogue, list(mraja1$fam.aff, mraja1$sex),
    units = "sentences", col.sep = "_")
    
    
## Animate It
##=================
ani_gannt <- with(DATA.SPLIT, gantt(state, person))
Animate(ani_gannt)
Animate(plot(ani_gannt))

library(animation)
loc <- reports::folder(animation_gantt)

## Set up the plotting function
oopt <- animation::ani.options(interval = 0.1)

FUN <- function() {
    out <- Animate(ani_gannt)
    lapply(out, function(x) {
        print(x)
        animation::ani.pause()
    })

}

type <- if(.Platform$OS.type == "windows") shell else system
saveGIF(FUN(), interval = 0.1, outdir = loc, cmd.fun = type)
}
}
\author{
DigEmAll (\url{stackoverflow.com}) and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
Clark, W. & Gantt, H. (1922) The Gantt chart, a working 
tool of management. New York, Ronald Press.
}
\seealso{
\code{\link[qdap]{gantt_rep}},
\code{\link[qdap]{gantt_wrap}},
\code{\link[qdap]{gantt_plot}}
}
\keyword{Gantt}

