% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_token_ratio.R
\name{type_token_ratio}
\alias{type_token_ratio}
\title{Type-Token Ratio}
\usage{
type_token_ratio(text.var, grouping.var = NULL, n.words = 1000, ...)
}
\arguments{
\item{text.var}{The text variable}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates 
one word list for all text.  Also takes a single grouping variable or a list 
of 1 or more grouping variables.}

\item{n.words}{An integer specifying the number of words in each chunk.}

\item{\ldots}{ignored.}
}
\value{
Returns a list of class \code{type_text_ratio}.  This object 
contains a type-token ratio for the overall text and a data frame
type-token ratios per grouping vriable.
}
\description{
Calculate type-token ratio by grouping variable.
}
\examples{
with(raj, type_token_ratio(dialogue, person))
plot(with(raj, type_token_ratio(dialogue, person)))
}
\references{
Baker, P. (2006) Using Corpora in Discourse Analysis. London: Continuum.
}
