% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mtabulate.R
\name{mtabulate}
\alias{mtabulate}
\title{Tabulate Frequency Counts for Multiple Vectors}
\usage{
mtabulate(vects)
}
\arguments{
\item{vects}{A \code{\link[base]{vector}}, \code{\link[base]{list}}, or
\code{\link[base]{data.frame}} of named/unnamed vectors.}
}
\value{
Returns a \code{\link[base]{data.frame}} with columns equal to
number of unique elements and the number of rows equal to the the original
length of the \code{\link[base]{vector}}, \code{\link[base]{list}}, or
\code{\link[base]{data.frame}} (length equals ncols in
\code{\link[base]{data.frame}}).  If list of vectors is named
these will be the rownames of the dataframe.
}
\description{
Similar to \code{\link[base]{tabulate}} that works on multiple vectors.
}
\examples{
mtabulate(list(w=letters[1:10], x=letters[1:5], z=letters))
mtabulate(list(mtcars$cyl[1:10]))

## Dummy coding
mtabulate(mtcars$cyl[1:10])
mtabulate(CO2[, "Plant"])

dat <- data.frame(matrix(sample(c("A", "B"), 30, TRUE), ncol=3))
mtabulate(dat)
t(mtabulate(dat))
counts2list(mtabulate(dat))
}
\author{
Joran Elias and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
\url{http://stackoverflow.com/a/9961324/1000343}
}
\seealso{
\code{\link[base]{tabulate}}, \code{\link[qdapTools]{counts2list}}
}
\keyword{frequency}
\keyword{tabulate}

