% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shift.R
\name{shift}
\alias{shift}
\alias{shift_left}
\alias{shift_right}
\title{Shift Vector Left/Right}
\usage{
shift(x, n, direction = "right")

shift_right(x, n)

shift_left(x, n)
}
\arguments{
\item{x}{A vector.}

\item{n}{The number of moves left or right to shift.}

\item{direction}{A direction to shift; must be either "left" or "right".
Use explicit directional shift functions \code{shift_right} and
\code{shift_left} for better performance.}
}
\value{
Returns a shifted vector.
}
\description{
Shift a vector left or right n spaces.
}
\examples{
lapply(0:9, function(i) shift(1:10, i))
lapply(0:9, function(i) shift(1:10, i, "left"))

## Explicit, faster shifting
lapply(0:9, function(i) shift_right(1:10, i))
lapply(0:9, function(i) shift_left(1:10, i))
lapply(0:25, function(i) shift_left(LETTERS, i))
}
\keyword{shift}

