% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{tqr.fit}
\alias{tqr.fit}
\title{Trigonometric Quantile Regression (TQR)}
\usage{
tqr.fit(y, f0, tau, prepared = TRUE)
}
\arguments{
\item{y}{vector of time series}

\item{f0}{frequency in [0,1)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{prepared}{if \code{TRUE}, intercept is removed and coef of cosine is doubled when \code{f0 = 0.5}}
}
\value{
object of \code{rq()} (coefficients in \code{$coef})
}
\description{
This function computes trigonometric quantile regression (TQR) for univariate time series at a single frequency.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
fit <- tqr.fit(y,f0=0.1,tau=tau)
plot(tau,fit$coef[1,],type='o',pch=0.75,xlab='QUANTILE LEVEL',ylab='TQR COEF')
}
