% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_chi_gamma.R
\name{comp_chi_gamma}
\alias{comp_chi_gamma}
\title{Compute gamma parameter of chi-square distance measure}
\usage{
comp_chi_gamma(sigs, cc, near_zero = 1e-05, min_gamma = 0.05, space = 1)
}
\arguments{
\item{sigs}{A matrix of fatty acid signatures ready for analysis. Intended to
be the object \code{sig_rep} returned by a call to the function
\code{\link{prep_sig}}.}

\item{cc}{A vector of calibration coefficients, intended to be the object
\code{cc} returned by the function \code{\link{prep_fa}} or
\code{cc_aug}.}

\item{near_zero}{A small constant used to terminate the algorithm. Default
value 0.00001.}

\item{min_gamma}{Smallest desired value of gamma, potentially used to
terminate the algorithm. Default value 0.05.}

\item{space}{An integer indicator of the estimation space to be used. Default
value 1.}
}
\value{
A list containing the following elements: \describe{
  \item{gamma}{The estimated value of gamma.}
  \item{gamma_vec}{A numeric vector containing the value of gamma at each
    step of the iteration.}
  \item{prop_vec}{A numeric vector containing the proportion of all possible
    two-element signatures with distance exceeding that of the full
    signatures at each step of the iteration. This value is compared to the
    argument near_zero.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
The function \code{comp_chi_gamma} computes the gamma parameter of the
chi-square distance measure using the algorithm of Stewart et al. (2014).
}
\section{Details}{

The chi-square distance involves a power transformation of signature
proportions, with the power parameter being denoted gamma.
\code{comp_chi_gamma} implements the algorithm of Stewart et al. (2014) to
find a suitable value of gamma.

The algorithm is initialized with inv_gamma equal to 1 and gamma is computed
as 1/inv_gamma. The distances between all possible pairs of full signatures
are computed (distances). For each pair of full signatures, the distances
between all possible sub-signatures comprised of only two fatty acid
proportions are computed (sub-distances). The proportion of sub-distances
that exceed the corresponding distance is computed across all possible pairs
of signatures. If that proportion is less than the argument near_zero, the
function returns with gamma equal to 1. Otherwise, the function enters an
iterative phase. At each iteration, inv_gamma is incremented by 1, gamma is
computed as 1/inv_gamma, distances and sub-distances are recomputed, and the
proportion of the sub-distances that exceed their corresponding distance is
recomputed. The algorithm terminates when the proportion is less than the
argument near_zero or the value of gamma is less than min_gamma.

The argument space must equal 1 or 2 (see \code{\link{est_diet}}). If its
value is 1, the calibration coefficients are used to map the signatures to
the predator space prior to initializing the algorithm.

As the number of signatures in the library and/or the number of fatty acids
in a signature increases, the number of possible pairs of signatures and the
number of all possible two-proportion sub-signatures increases rapidly.
Consequently, this algorithm may require long run times. However, it only
needs to be run once for any particular library of signatures.
}

\section{References}{

Stewart, C., S. Iverson, and C. Field. 2014. Testing for a change in diet
  using fatty acid signatures. \emph{Environmental and Ecological Statistics}
  21:775-792.
}
\examples{
comp_chi_gamma(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                               0.04, 0.11, 0.29, 0.56,
                               0.10, 0.05, 0.35, 0.50,
                               0.12, 0.03, 0.37, 0.48,
                               0.10, 0.06, 0.35, 0.49,
                               0.05, 0.15, 0.35, 0.45), ncol=6),
               cc = c(0.75, 1.00, 1.50, 0.90),
               near_zero = 0.000001,
               min_gamma = 0.10,
               space = 1)

comp_chi_gamma(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                               0.04, 0.11, 0.29, 0.56,
                               0.10, 0.05, 0.35, 0.50,
                               0.12, 0.03, 0.37, 0.48,
                               0.10, 0.06, 0.35, 0.49,
                               0.05, 0.15, 0.35, 0.45), ncol=6),
               cc = c(0.75, 1.00, 1.50, 0.90))

}

