% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_learnFast.R
\name{check.learnFast}
\alias{check.learnFast}
\title{Visual checks for the output of tuneLearnFast()}
\usage{
\method{check}{learnFast}(obj, sel = NULL, ...)
}
\arguments{
\item{obj}{the output of a call to \code{tuneLearnFast}.}

\item{sel}{integer vector determining which of the plots will be produced. For instance if \code{sel = c(1, 3)} only
the 1st and 3rd plots are showed. No entry of \code{sel} can be bigger than one plus the number of quantiles considered
in the original \code{tuneLearnFast()} call. That is, if we estimated the learning rate for \code{qu = c(0.1, 0.4)},
then \code{max(sel)} must be <= 3.}

\item{...}{currently not used, here only for compatibility reasons.}
}
\value{
It produces several plots.
}
\description{
Provides some visual checks to verify whether the Brent optimizer used by \code{tuneLearnFast()} worked correctly.
}
\details{
The top plot in the first page shows the bracket used to estimate log(sigma) for each quantile.
         The brackets are delimited by the crosses and the red dots are the estimates. If a dot falls very close to one of the crosses, 
         that might indicate problems. The bottom plot shows, for each quantile, the value of parameter \code{err} used. Sometimes the algorithm
         needs to increase \code{err} above its user-defined value to achieve convergence. Subsequent plots show, for each quantile, the value
         of the loss function corresponding to each value of log(sigma) explored by Brent algorithm.
}
\examples{
library(qgam)
set.seed(525)
dat <- gamSim(1, n=200)
b <- tuneLearnFast(y ~ s(x0)+s(x1)+s(x2)+s(x3), 
                   data = dat, qu = c(0.4, 0.5), 
                   control = list("tol" = 0.05)) # <- sloppy tolerance to speed-up calibration 
check(b) 
check(b, 3) # Produces only third plot

}
\references{
Fasiolo, M., Goude, Y., Nedellec, R. and Wood, S. N. (2017). Fast calibrated additive quantile regression. 
            Available at \url{https://arxiv.org/abs/1707.03307}.
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
