% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{quantize}
\alias{quantize}
\title{create variables representing indicator functions with cutpoints defined
by quantiles}
\usage{
quantize(data, expnms, q = 4, breaks = NULL)
}
\arguments{
\item{data}{a data frame}

\item{expnms}{a character vector with the names of  the columns to be
quantized}

\item{q}{integer, number of quantiles used in creating quantized variables}

\item{breaks}{(optional) list of (equal length) numeric vectors that 
characterize the minimum value of each category for which to 
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}
}
\description{
This function creates categorical variables in place of the
exposure variables named in 'expnms.' For example, a continuous exposure
'x1' will be replaced in the output data by another 'x1' that takes on values
0:(q-1), where, for example, the value 1 indicates that the original x1 value
falls between the first and the second quantile.
}
\details{
This function is a vectorized version of `quantile_f` from the `gWQS` 
package that also allows the use of externally defined breaks
}
\examples{
set.seed(1232)
dat = data.frame(y=runif(100), x1=runif(100), x2=runif(100), z=runif(100))
qdata = quantize(data=dat, expnms=c("x1", "x2"), q=4)
table(qdata$data$x1)
table(qdata$data$x2)
summary(dat[c('y', 'z')]);summary(qdata$data[c('y', 'z')]) # not touched
}
\keyword{mixtures}
\keyword{variance,}
