% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_zi.R
\name{qgcomp.zi.noboot}
\alias{qgcomp.zi.noboot}
\title{estimating the parameters of a zero-inflated marginal structural model (MSM) based on 
g-computation with quantized exposures}
\usage{
qgcomp.zi.noboot(
  f,
  data,
  expnms = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  alpha = 0.05,
  bayes = FALSE,
  ...
)
}
\arguments{
\item{f}{R style formula using syntax from 'pscl' package: depvar ~ indvars_count | indvars_zero}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that 
characterize the minimum value of each category for which to 
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{id}{(optional) NULL, or variable name indexing individual units of 
observation (only needed if analyzing data with multiple observations per 
id/cluster)}

\item{alpha}{alpha level for confidence limit calculation}

\item{bayes}{not yet implemented}

\item{...}{arguments to zeroinf (e.g. dist)}
}
\value{
a qgcompfit object, which contains information about the effect
 measure of interest (psi) and associated variance (var.psi), as well
 as information on the model fit (fit) and information on the 
 weights/standardized coefficients in the positive (pos.weights) and 
 negative (nweight) directions.
}
\description{
This function mimics the output of a weighted quantile sums regression in 
large samples.
}
\details{
A zero-inflated version of quantile g-computation based on the implementation in the
'pscl' package. A zero-inflated distribution is a mixture distribution in which one of the
distributions is a point mass at zero (with probability given by a logistoic model), and the 
other distribution is a discrete or continuous distribution.
This estimates the effect of a joint increase in all exposures on 1) the odds 
of belonging to the "zero" vs. "count" portions of the distribution and/or 2) the rate parameter
for the "count" portion of the distribution.
}
\examples{
set.seed(50)
n=100
dat <- data.frame(y=rbinom(n, 1, 0.5)*rpois(n, 1.2), x1=runif(n), x2=runif(n), z=runif(n))
# poisson count model, mixture in both portions
qgcomp.zi.noboot(f=y ~ z + x1 + x2 | x1 + x2, expnms = c('x1', 'x2'), 
    data=dat, q=2, dist="poisson")
# negative binomial count model, mixture and covariate in both portions
qgcomp.zi.noboot(f=y ~ z + x1 + x2 | z + x1 + x2, expnms = c('x1', 'x2'), 
   data=dat, q=2, dist="negbin")  
qgcomp.zi.noboot(f=y ~ z + x1 + x2, expnms = c('x1', 'x2'), 
   data=dat, q=2, dist="negbin") # equivalent
# negative binomial count model, mixture only in the 'count' portion of the model
qgcomp.zi.noboot(f=y ~ z + x1 + x2 | z, expnms = c('x1', 'x2'), data=dat, q=2, dist="negbin")
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}}, \code{\link[qgcomp]{qgcomp.cox.noboot}}, 
 and \code{\link[pscl]{zeroinfl}}
}
\concept{variance mixtures}
