% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_plot.R
\name{plot.qgcompemmfit}
\alias{plot.qgcompemmfit}
\title{Default plotting method for a qgcompfit object}
\usage{
\method{plot}{qgcompemmfit}(x, emmval = 0, suppressprint = FALSE, ...)
}
\arguments{
\item{x}{"qgcompfit" object from \code{qgcomp.noboot},  \code{qgcomp.boot},
\code{qgcomp.cox.noboot},  \code{qgcomp.cox.boot}, \code{qgcomp.zi.noboot} or \code{qgcomp.zi.boot} functions}

\item{emmval}{fixed value for effect measure modifier at which pointwise comparisons are calculated}

\item{suppressprint}{If TRUE, suppresses the plot, rather than printing it
by default (it can be saved as a ggplot2 object (or list of ggplot2 objects if x is from a zero-
inflated model) and used programmatically)
(default = FALSE)}

\item{...}{unused}
}
\value{
If suppressprint=FALSE, then this function prints a plot specific to a "qgcompemmfit" object.
If no bootstrapping is used, it will print a butterfly plot of the weights at the specified value of the modifier (set via \code{emmval} parameter)
If bootstrapping is used, it will print a joint regression line for all exposures at the specified value of the modifier (set via \code{emmval} parameter)

If suppressprint=TRUE, then this function returns a "gg" (regression line) or "gtable" (butterfly plot) object (from ggplot2 package or gtable/grid packages), which can be used to print a ggplot figure and modify either of the above figures (see example below)
}
\description{
Plot a quantile g-computation object. For qgcomp.noboot, this function will
create a butterfly plot of weights. For qgcomp.boot, this function will create
a box plot with smoothed line overlaying that represents a non-parametric
fit of a model to the expected outcomes in the population at each quantile
of the joint exposures (e.g. '1' represents 'at the first quantile for
every exposure')
}
\examples{
set.seed(50)
# linear model, binary modifier
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
z=rbinom(50,1,0.5), r=rbinom(50,1,0.5))
(qfit <- qgcomp.emm.noboot(f=y ~ z + x1 + x2, emmvar="z",
expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
plot(qfit, emmval = 1)
#
library(ggplot2)

# example with bootstrapping
dat2 <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
z=sample(0:2, 50,replace=TRUE), r=rbinom(50,1,0.5))
dat2$z = as.factor(dat2$z)
(qfit4 <- qgcomp.emm.boot(f=y ~ z + x1 + x2, emmvar="z",
                          degree = 1, B = 20,
                         expnms = c('x1', 'x2'), data=dat2, q=4, family=gaussian()))
plot(qfit4)
pp = plot(qfit4, emmval=2, suppressprint=TRUE)
pp + theme_linedraw() # can use with other ggplot functions

\dontrun{
# example with no bootstrapping, adding object from bootstrapped fit
pp2 <- plot(qfit, emmval = 1, suppressprint=TRUE)
grid.draw(pp2)
# insert row on top that is 1/2 height of existing plot
pp2b = gtable::gtable_add_rows(pp2, heights=unit(0.5, 'null') ,pos = 0)
# add plot to that row
pp3 = gtable::gtable_add_grob(pp2b, ggplot2::ggplotGrob(pp), t=1,l=1,r=2)
grid.draw(pp3)
}
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}}, \code{\link[qgcomp]{qgcomp.boot}}, and \code{\link[qgcomp]{qgcomp}}
}
