% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-run-algorithm.R
\name{qgis_run_algorithm}
\alias{qgis_run_algorithm}
\title{Run an algorithm using 'qgis_process'}
\usage{
qgis_run_algorithm(
  algorithm,
  ...,
  PROJECT_PATH = NULL,
  ELLIPSOID = NULL,
  .raw_json_input = NULL,
  .quiet = TRUE
)
}
\arguments{
\item{algorithm}{A qualified algorithm name (e.g., \code{"native:buffer"}) or
a path to a QGIS model file.}

\item{...}{Named key-value pairs as arguments for the algorithm. Features of
\code{\link[rlang:list2]{rlang::list2()}} are supported. These arguments
are converted to strings using \code{\link[=as_qgis_argument]{as_qgis_argument()}}.}

\item{PROJECT_PATH, ELLIPSOID}{Global values for QGIS project file and
ellipsoid name for distance calculations.}

\item{.raw_json_input}{The raw JSON to use as input in place of \code{...}.}

\item{.quiet}{Use \code{FALSE} to get extra output from 'qgis_process'.
This can be useful in debugging.}
}
\value{
A \code{qgis_result} object.
}
\description{
Runs an algorithm using 'qgis_process'.
See the \href{https://docs.qgis.org/latest/en/docs/user_manual/processing_algs/}{QGIS docs}
for a detailed description of the algorithms provided
'out of the box' on QGIS.
}
\details{
\code{qgis_run_algorithm()} accepts various R objects as algorithm arguments.
Examples include an R matrix or data frame for the
argument type 'matrix', R colors for the argument type 'color',
sf or terra (SpatVector) objects for the argument type 'vector' and
raster/terra/stars objects for the argument type 'raster', but there are many
more.
\code{qgis_run_algorithm()} preprocesses the provided objects into the format that
QGIS expects for a given argument.

For data objects in R that already exist as a stored file, it is best to
instead provide the file path in order to prevent a superfluous file writing
step from R, as QGIS expects a file path.
However terra and stars objects can contain the file path as metadata: in
these cases this path is retrieved from the R object and passed to QGIS;
potential pitfalls are taken care of.

Providing R objects that cannot be converted to the applicable argument type
will lead to an error.
}
\section{Running QGIS models and Python scripts}{

QGIS models and Python scripts can be added to the Processing Toolbox in the
QGIS GUI, by pointing at their corresponding file.
This will put the model or script below the provider 'Models' or
'Scripts', respectively.
Next, it is necessary to run \code{\link[=qgis_configure]{qgis_configure()}} in R in order to make the
model or script available to qgisprocess (even reloading the package won't
detect it, since these providers have dynamic content, not tied to a
plugin or to a QGIS version).
You can check the outcome with \code{\link[=qgis_providers]{qgis_providers()}} and
\code{\link[=qgis_search_algorithms]{qgis_search_algorithms()}}.
Now, just as with other algorithms, you can provide the \verb{model:<name>} or
\verb{script:<name>} identifier to the \code{algorithm} argument of
\code{qgis_run_algorithm()}.

As the output argument name of a QGIS model can have an R-unfriendly
syntax, you may need to take the JSON parameter string from the QGIS
processing dialog and feed the JSON string to the \code{.raw_json_input} argument
of \code{qgis_run_algorithm()} instead of providing separate arguments.

Although the 'qgis_process' backend also supports replacing the 'algorithm'
parameter by the file path of a model file or a Python script, it is not
planned to implement this in qgisprocess, as it would bypass argument
preprocessing in R (including checks).
}

\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_run_algorithm(
  "native:buffer",
  INPUT = system.file("longlake/longlake_depth.gpkg", package = "qgisprocess"),
  DISTANCE = 10
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions to run one geoprocessing algorithm: 
\code{\link{qgis_run_algorithm_p}()}
}
\concept{functions to run one geoprocessing algorithm}
