% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_serialize}
\alias{qd_serialize}
\title{qd_serialize}
\usage{
qd_serialize(object, compress_level = 3L, shuffle = TRUE, 
warn_unsupported_types = TRUE, nthreads = 1L)
}
\arguments{
\item{object}{The object to save.}

\item{compress_level}{The compression level used (default 3).

The maximum and minimum possible values depends on the version of ZSTD library used.
As of ZSTD 1.5.6 the maximum compression level is 22, and the minimum is -131072. Usually, values in the low positive range offer very good performance in terms
of speed and compression.}

\item{shuffle}{Whether to allow byte shuffling when compressing data (default: \code{TRUE}).}

\item{warn_unsupported_types}{Whether to warn when saving an object with an unsupported type (default \code{TRUE}).}

\item{nthreads}{The number of threads to use when compressing data (default: \code{1}).}
}
\value{
The serialized object as a raw vector.
}
\description{
Serializes an object to a raw vector using the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(state.name, 1e3, replace=TRUE),
        stringsAsFactors = FALSE)
xserialized <- qd_serialize(x)
x2 <- qd_deserialize(xserialized)
identical(x, x2) # returns true
}
