% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase_estimation.R
\name{phase_estimation}
\alias{phase_estimation}
\title{phase_estimation}
\usage{
phase_estimation(bitmask, FUN, x, ...)
}
\arguments{
\item{bitmask}{integer. Vector of qubits for the t qubit wide
register needed for the phase estimation}

\item{FUN}{a function implementing the controlled application of
a unitary operator U to the power 2^(j-1) to the state x. It's first
argument must be the control qubit 'c', the second the integer 'j'
and the third the state 'x'. Additional parameters can be passed
via '...'.}

\item{x}{a 'qstate' object}

\item{...}{additional parameter to be passed on to 'FUN'}
}
\description{
phase estimation algorithm
}
\examples{
## NOT^k = Id if k even
cnotwrapper <- function(c, j, x, t) {
  if(j == 1) return(CNOT(c(c, t)) * x)
  return(Id(t) * x)
}
x <- X(1) * qstate(3)
## X has eigenvalues lambda=1 and lambda=-1
## thus phases 0 and 1/2
x <- phase_estimation(bitmas=c(2:3), FUN=cnotwrapper, x=x, t=1)
x

}
