% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qft.R
\name{qft}
\alias{qft}
\title{qft}
\usage{
qft(x, inverse = FALSE, bits)
}
\arguments{
\item{x}{qstate}

\item{inverse}{boolean. If 'TRUE', perform inverse transform}

\item{bits}{integer. list of qubits to include in the trafo. if
missing, \code{bits=c(1:n)} is assumed, with \code{n} the number of qubits
in \code{x}.}
}
\value{
a \code{qstate} object with the quantum Fourier trafo of input \code{x}.
}
\description{
performs the quantum Fourier Trafo on the qstate x and the
specified list of qubits.
}
\details{
Quantum Fourier Trafo

The Fourier Trafo is defined as
\deqn{|j> -> 1/sqrt(N) sum_k=0^N_1 exp(2 pi i j k/N) |k>}
the inverse with the oposite sign in the exponential.
}
\examples{
x <- qstate(3)
y <- qft(x)
z <- qft(y, inverse=TRUE)

}
