% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_path.R
\name{fst_path}
\alias{fst_path}
\title{Path used in fst_genoprob object}
\usage{
fst_path(object)
}
\arguments{
\item{object}{An object of class \code{"fst_genoprob"} as created by \code{\link[=fst_genoprob]{fst_genoprob()}}.}
}
\value{
Character string with path (and initial file stem) for files used in the input \code{object}.
}
\description{
Get the path used in an fst_genoprob object.
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
probs <- calc_genoprob(grav2, error_prob=0.002)
dir <- tempdir()
fprobs <- fst_genoprob(probs, "grav2", dir, overwrite=TRUE)

fst_path(fprobs)
fst_files(fprobs)

# clean up: remove all the files we created
unlink(fst_files(fprobs))
}
\seealso{
\code{\link[=fst_files]{fst_files()}}, \code{\link[=replace_path]{replace_path()}}
}
