% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpprob_collapse.R
\name{snpprob_collapse}
\alias{snpprob_collapse}
\title{Collapse genoprob according to pattern}
\usage{
snpprob_collapse(
  snpprobs,
  action = c("additive", "add+dom", "non-add", "recessive", "dominant", "basic")
)
}
\arguments{
\item{snpprobs}{object of class \code{\link[qtl2]{calc_genoprob}}}

\item{action}{SNP gene action type}
}
\value{
object of class \code{\link[qtl2]{calc_genoprob}}
}
\description{
Collapse genoprob according to pattern
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

# Read DOex example cross from 'qtl2data'
DOex <- subset(qtl2::read_cross2(file.path(dirpath, "DOex.zip")), chr = "2")

\donttest{
# Download genotype probabilities
tmpfile <- tempfile()
download.file(file.path(dirpath, "DOex_genoprobs_2.rds"), tmpfile, quiet=TRUE)
pr <- readRDS(tmpfile)
unlink(tmpfile)

# Download SNP info for DOex from web and read as RDS.
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_snpinfo.rds"), tmpfile, quiet=TRUE)
snpinfo <- readRDS(tmpfile)
unlink(tmpfile)
snpinfo <- dplyr::rename(snpinfo, pos = pos_Mbp)

# Convert to snp probabilities
snpinfo <- qtl2::index_snps(DOex$pmap, snpinfo)
snppr <- qtl2::genoprob_to_snpprob(pr, snpinfo)


dim(snppr[[1]])
dim(snpprob_collapse(snppr, "additive")[[1]])
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
