% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_snps_pattern.R
\name{top_snps_pattern}
\alias{top_snps_pattern}
\alias{summary.top_snps_pattern}
\alias{subset.top_snps_pattern}
\title{Top SNPs organized by allele pattern}
\usage{
top_snps_pattern(
  scan1_output,
  snpinfo,
  drop = 1.5,
  show_all_snps = TRUE,
  haplos
)

\method{summary}{top_snps_pattern}(object, sum_type = c("range", "best", "peak"), ...)

\method{subset}{top_snps_pattern}(x, start_val = 0, end_val = max(x$pos), pheno = NULL, ...)
}
\arguments{
\item{scan1_output}{output of linear mixed model for \code{phename} (see \code{\link[qtl2]{scan1}})}

\item{snpinfo}{Data frame with SNP information with the following
    columns (the last three are generally derived from with
    \code{\link[qtl2]{index_snps}}):
\itemize{
\item \code{chr} - Character string or factor with chromosome
\item \code{pos} - Position (in same units as in the \code{"map"}
    attribute in \code{genoprobs}.
\item \code{sdp} - Strain distribution pattern: an integer, between
    1 and \eqn{2^n - 2} where \eqn{n} is the number of strains, whose
    binary encoding indicates the founder genotypes
\item \code{snp_id} - Character string with SNP identifier (if
    missing, the rownames are used).
\item \code{index} - Indices that indicate equivalent
    groups of SNPs.
\item \code{intervals} - Indexes that indicate which marker
    intervals the SNPs reside.
\item \code{on_map} - Indicate whether SNP coincides with a marker
    in the \code{genoprobs}
}}

\item{drop}{include all SNPs within \code{drop} of max LOD (default 1.5)}

\item{show_all_snps}{show all SNPs if \code{TRUE}}

\item{haplos}{optional argument identify codes for haplotypes}

\item{object}{object of class \code{top_snps_tbl}}

\item{sum_type}{type of summary (one of "range","best")}

\item{...}{additional parameters ignored}

\item{x}{tbl of feature information from \code{\link{get_feature_snp}}}

\item{start_val, end_val}{start and end positions for subset}

\item{pheno}{phenotype name(s) for subset}
}
\value{
table of top_snps at maximum lod for \code{pattern}

table summary

subset of \code{x}
}
\description{
Separate fine mapping scans by allele pattern.
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

# Read DOex example cross from 'qtl2data'
DOex <- subset(qtl2::read_cross2(file.path(dirpath, "DOex.zip")), chr = "2")

\donttest{
# Download genotype probabilities
tmpfile <- tempfile()
download.file(file.path(dirpath, "DOex_genoprobs_2.rds"), tmpfile, quiet=TRUE)
pr <- readRDS(tmpfile)
unlink(tmpfile)

# Download SNP info for DOex from web and read as RDS.
tmpfile <- tempfile()
download.file(file.path(dirpath, "c2_snpinfo.rds"), tmpfile, quiet=TRUE)
snpinfo <- readRDS(tmpfile)
unlink(tmpfile)
snpinfo <- dplyr::rename(snpinfo, pos = pos_Mbp)

# Convert to SNP probabilities
snpinfo <- qtl2::index_snps(DOex$pmap, snpinfo)
snppr <- qtl2::genoprob_to_snpprob(pr, snpinfo)

# Scan SNPs.
scan_snppr <- qtl2::scan1(snppr, DOex$pheno)

# Collect top SNPs
top_snps_tbl <- top_snps_pattern(scan_snppr, snpinfo)
summary(top_snps_tbl)
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
