% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genoprob_to_patternprob.R
\name{genoprob_to_patternprob}
\alias{genoprob_to_patternprob}
\title{Collapse genoprob according to pattern}
\usage{
genoprob_to_patternprob(probs1, sdp, alleles = FALSE)
}
\arguments{
\item{probs1}{object of class \code{\link[qtl2]{calc_genoprob}}}

\item{sdp}{SNP distribution pattern}

\item{alleles}{use allele string if \code{TRUE}}
}
\value{
object of class \code{\link[qtl2]{calc_genoprob}}
}
\description{
Collapse genoprob according to pattern
}
\examples{
dirpath <- "https://raw.githubusercontent.com/rqtl/qtl2data/master/DOex"

# Read DOex example cross from 'qtl2data'
DOex <- subset(qtl2::read_cross2(file.path(dirpath, "DOex.zip")), chr = "2")

\donttest{
# Download genotype probabilities
tmpfile <- tempfile()
download.file(file.path(dirpath, "DOex_genoprobs_2.rds"), tmpfile, quiet=TRUE)
pr <- readRDS(tmpfile)
unlink(tmpfile)

# Convert genotype probabilities to pattern probabilities for pattern 1.
pattern_pr <- genoprob_to_patternprob(pr, 7, TRUE)

str(pr)
str(pattern_pr)
}

}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}
}
\keyword{utilities}
