% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_lrt_tib.R
\name{calc_lrt_tib}
\alias{calc_lrt_tib}
\title{Calculate a likelihood ratio test statistic from the output of scan_pvl()}
\usage{
calc_lrt_tib(scan_pvl_out)
}
\arguments{
\item{scan_pvl_out}{outputted tibble from scan_pvl}
}
\value{
a number, the (log) likelihood ratio test statistic
}
\description{
Calculate a likelihood ratio test statistic from the output of scan_pvl()
}
\examples{
rep(paste0('Marker', 1:3), times = 3) -> marker1
rep(paste0('Marker', 1:3), each = 3) -> marker2
runif(9, -1, 0) -> ll
tibble::tibble(marker1, marker2, ll) -> scan_out
calc_lrt_tib(scan_out)
}
