% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_multi_onechr.R
\name{scan_multi_onechr}
\alias{scan_multi_onechr}
\title{Perform multivariate, one-QTL model fitting for markers on one chromosome}
\usage{
scan_multi_onechr(
  probs,
  pheno,
  kinship = NULL,
  addcovar = NULL,
  start_snp = 1,
  n_snp = dim(probs)[3],
  max_iter = 10000,
  max_prec = 1/1e+08,
  cores = 1
)
}
\arguments{
\item{probs}{an array of founder allele probabilities for a single chromosome}

\item{pheno}{a matrix of phenotypes}

\item{kinship}{a kinship matrix for one chromosome}

\item{addcovar}{a matrix, n subjects by c additive covariates}

\item{start_snp}{index of where to start the scan within probs}

\item{n_snp}{the number of (consecutive) markers to include in the scan}

\item{max_iter}{maximum number of iterations for EM algorithm}

\item{max_prec}{stepwise precision for EM algorithm. EM stops once incremental difference in log likelihood is less than max_prec}

\item{cores}{number of cores for parallelization}
}
\value{
a tibble with d + 1 columns. First d columns indicate the genetic data (by listing the marker ids) used in the design matrix; last is log10 likelihood
}
\description{
`scan_multi_onechr` calculates log likelihood for d-variate phenotype model fits. Inputted parameter `start_snp` indicates where in the `probs` object to start the scan.
}
\examples{
# read data
n <- 50
pheno <- matrix(rnorm(2 * n), ncol = 2)
rownames(pheno) <- paste0("s", 1:n)
colnames(pheno) <- paste0("tr", 1:2)
probs <- array(dim = c(n, 2, 5))
probs[ , 1, ] <- rbinom(n * 5, size = 1, prob = 0.2)
probs[ , 2, ] <- 1 - probs[ , 1, ]
rownames(probs) <- paste0("s", 1:n)
colnames(probs) <- LETTERS[1:2]
dimnames(probs)[[3]] <- paste0("m", 1:5)
scan_multi_onechr(probs = probs, pheno = pheno, kinship = NULL, cores = 1)

}
\references{
Knott SA, Haley CS (2000) Multitrait
least squares for quantitative trait loci detection.
Genetics 156: 899–911.

Jiang C, Zeng ZB (1995) Multiple trait analysis
of genetic mapping for quantitative trait loci.
Genetics 140: 1111-1127.

Zhou X, Stephens M (2014) Efficient multivariate linear
mixed model algorithms for genome-wide association studies.
Nature methods 11:407-409.

Broman KW, Gatti DM, Simecek P, Furlotte NA, Prins P, Sen S, Yandell BS, Churchill GA (2019)
R/qtl2: software for mapping quantitative trait loci with high-dimensional data and
multi-parent populations. GENETICS https://www.genetics.org/content/211/2/495.
}
