% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_rm.R
\name{keep_rm}
\alias{keep_rm}
\title{Keep or remove rows and columns from data frame}
\usage{
keep_rm(
  data,
  values,
  select,
  keep = TRUE,
  drop_levels = TRUE,
  exact = TRUE,
  colname
)
}
\arguments{
\item{data}{A data frame.}

\item{values}{A vector containing the characters or parts of characters to base
selection off of.}

\item{select}{If \code{select = "row"}, rows containing the \code{values} will be selected
for either being kept, or being removed, as specified by \code{keep}. If
\code{select = "col"}, columns with names containing the \code{values} will either be
kept or removed, as specified by \code{keep}.}

\item{keep}{If \code{keep = TRUE} the presence of the \code{values} will cause the
selected rows or columns to be kept. If \code{keep = FALSE} the presence of
the \code{values} will cause the selected rows or columns to be removed.}

\item{drop_levels}{If \code{drop_levels = TRUE}, factor levels that have been
removed will be dropped. Only applicable when \code{select = "row"}}

\item{exact}{If \code{exact = TRUE} only exact matches will be selected. If
\code{exact = FALSE} matches will be selected if they contain the characters in the
\code{values} vector and will not be limited to exact matches only.}

\item{colname}{If \code{select = "row"}, \code{colname} will specify the column to
select rows from.}
}
\value{
A data frame containing new selection of data.
}
\description{
Using a character, or part of character select rows or columns
of the data frame to either keep or remove. A more customizable way to
subset your data as you can keep or remove based on partial matches, or
cells containing select characters.
}
\examples{
# create data frame
Sites <- as.factor(c("One", "One", "One", "Two", "Two", "Three"))
Transect <- as.factor(c("1-Deep", "1-Shallow", "2-Shallow", "1-Shallow", "1-Deep", "1-Deep"))
Acropora.sp <- c(0.1, 0.6, 0.4, 0.9, 0.2, 0.5)
Gardineroseris.sp <- c(0.4, 0.9, 0.5, 0.23, 0.5, NA)
Psammocora.sp <- c(0.9, 0.6, 0.5, 0.8, 0.1, 0.4)
Leptastrea.sp <- c(0.5, 0.7, 0.4, 0.8, 0.2, NA)
Notes <- c(NA, NA, "saw octopus", NA, "white balance corrected", NA)
coral_cover <- data.frame(Sites, Transect, Acropora.sp, Gardineroseris.sp,
                         Psammocora.sp, Leptastrea.sp, Notes)

#Removing Notes column
keep_rm(data = coral_cover, values = c("Notes") , select = "col",
   keep = FALSE, drop_levels = FALSE, exact = TRUE)

#Selecting site One and dropping extra levels
Site_One <- keep_rm(data = coral_cover, values = c("One") , select = "row",
   keep = TRUE, drop_levels = TRUE, exact = TRUE, "Sites")
levels(Site_One$Sites)

#Removing Deep sites
Shallow_Sites <- keep_rm(data = coral_cover, values = c("-Shallow") , select ="row",
   keep = FALSE, drop_levels = TRUE, exact = FALSE, "Transect")

#Selecting only species data
Species <- keep_rm(data = coral_cover, values = c(".sp") , select ="col",
   keep = TRUE, drop_levels = TRUE, exact = FALSE)
}
