% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{qualpal}
\alias{qualpal}
\title{Generate qualitative color palettes}
\usage{
qualpal(n, colorspace = "pretty", colorblind = c("normal", "protan",
  "deutan"), ...)
}
\arguments{
\item{n}{The number of colors to generate.}

\item{colorspace}{Either 1) a list of three named numeric vectors: \code{h}
(hue), \code{s} (saturation), and \code{l} (lightness), all of length 2
specifying a min and max value for the range. The values has to be in the
range -360 to 360 for \code{h}, and 0 to 1 for \code{s} and \code{l} 2), or
2) a \emph{character vector} specifying one of the predefined color spaces
(see below).}

\item{colorblind}{Set to \code{"protan"} or \code{"deutan"} to adapt the color
palette to protanopia or deuteranopia respectively. The default is no
adapation (\code{"normal"}).}

\item{...}{Deprecated.}
}
\value{
qualpal returns a list of class "qualpal" with the following
  components.
  \item{HSL}{A matrix of the colors in the HSL color space.}
  \item{DIN99d}{A matrix of the colors in the DIN99d color space.}
  \item{RGB}{A matrix of the colors in the sRGB color space.}
  \item{hex}{A character vector of the colors in hex notation.}
  \item{de_DIN99d}{A distance matrix of color differenes according to delta E
    DIN99d.}
  \item{min_de_DIN99d}{The smallest pairwise delta E DIN99d.}
}
\description{
Takes a subset of the HSL color space, projects it to the DIN99d color space,
and generates a color palette from the most distinct colors.
}
\details{
\code{qualpal} takes a color subspace in the HSL color space, where lightness
and saturation take values from 0 to 1. Hue take values from -360 to 360,
although negative values are brought to lie in the range \{0, 360\} under the
hood. This behavior exists to enable color subspaces that span any hue range
(since the hue range is circular).

The HSL color subspace that the user provides is projected into the DIN99d
color space, which is approximately perceptually uniform, i.e. color
difference is proportional to the euclidean distance between colors. A
distance matrix is computed and transformed using power transformations
discovered by Huang 2015 in order to fine tune differences.

\code{qualpal} then greedily searches the distance matrix for the most distinct
colors; it does this iteratively by first selecting the two most distinct
colors, then finding the third that has the smallest pairwise distance to the
previously selected points, repeating this until `n` colors have been
collected.

Optionally, \code{qualpal} can adapt palettes to cater to color blindness, or
more specifically dichromacy. This is
accomplished by taking the colors provided by the user and
transforming them to colors that a protan or deutan would see, that is,
simulating dichromacy. qualpal then chooses colors from these new colors.

\code{qualpal} currently only supports the sRGB color space with the D65
white point reference.
}
\section{Predefined color spaces}{
 Instead of specifying a color space
  manually, the following predefined color spaces can by accessed by
  specifying their name as a character vector to \code{colorspace}.
  \describe{
  \item{\code{pretty}}{Tries to provide aesthetically pleasing, but still
  distinct color palettes. Hue ranges from 0 to 360, saturation from 0.1 to
  0.5, and lightness from 0.5 to 0.85. Is not suitable for large numbers of
  \code{n}}
  \item{\code{pretty_dark}}{Like \code{pretty} but darker. Hue ranges from 0
  to 360, saturation from 0.1 to 0.5, and lightness from 0.2 to 0.4.}
  \item{\code{rainbow}}{Uses all hues, chromas, and most of the lightness
  range. Provides distinct but not aesthetically pleasing colors.}
  \item{\code{pastels}}{Pastel colors from the complete range of hues
  (0-360), with saturation between 0.2 and 0.4, and lightness between 0.8 and
  0.9.}
  }
}
\examples{
# generates 3 distinct colors from the default color subspace
qualpal(3)
qualpal(n = 3, list(h = c(35, 360), s = c(.5, .7), l = c(0, .45)))

qualpal(3, "pretty")

# Adapt color palette to deuteranopia
qualpal(5, colorspace = "pretty_dark", colorblind = "deutan")

\dontrun{
# The range of hue cannot exceed 360
qualpal(n = 3, list(h = c(-20, 360), s = c(.5, .7), l = c(0, .45)))
}
}
\seealso{
\code{\link{plot.qualpal}},
  \code{\link{pairs.qualpal}}
}

