% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValuesForVolcano.R
\name{getTValuesForVolcano}
\alias{getTValuesForVolcano}
\title{get p-values of t-test values for volcano}
\usage{
getTValuesForVolcano(x, y, alternative = "two.sided")
}
\arguments{
\item{x}{- one data matrix}

\item{y}{- second data matrix}

\item{alternative}{two.sided, less, greater}
}
\value{
list with three fields fchange (fold change) , pval and pvaladj
}
\description{
get p-values of t-test values for volcano
}
\examples{
a <- t(replicate(200,rnorm(20,runif(1,-3,3),1)))
b <- a[1:100,]
a <- a[101:200,]
boxplot(t(a[1:20,]))
boxplot(t(b[1:20,]))
res <- getTValuesForVolcano(a,b)
volcanoplot(res$fchange , res$pval)

}
