% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ngrams.R
\name{ngrams}
\alias{ngrams}
\title{Create ngrams}
\usage{
ngrams(text, n = 2, concatenator = "_", include.all = FALSE, ...)
}
\arguments{
\item{text}{character vector containing the texts from which ngrams will be extracted}

\item{n}{the number of tokens to concatenate. Default is 2 for bigrams.}

\item{concatenator}{character for combining words, default is \code{_} (underscore) character}

\item{include.all}{if TRUE, add n-1...1 grams to the returned list}

\item{...}{additional parameters}
}
\value{
a list of character vectors of ngrams, one list element per text
}
\description{
Create a set of ngrams (words in sequence) from text(s) in a character vector
}
\details{
\code{...} provides additional arguments passed to \link{tokenize}
}
\examples{
ngrams("The quick brown fox jumped over the lazy dog.", n=2)
identical(ngrams("The quick brown fox jumped over the lazy dog.", n=2),
          bigrams("The quick brown fox jumped over the lazy dog.", n=2))
ngrams("The quick brown fox jumped over the lazy dog.", n=3)
ngrams("The quick brown fox jumped over the lazy dog.", n=3, concatenator="~")
ngrams("The quick brown fox jumped over the lazy dog.", n=3, include.all=TRUE)
}
\author{
Ken Benoit, Kohei Watanabe, Paul Nulty
}

